;
; Copyright (c) Microsoft Corporation. All rights reserved.
;
; You may only use this code if you agree to the terms of the Windows Research Kernel Source Code License agreement (see License.txt).
; If you do not agree to the terms, do not use the code.
;

IFDEF NEC_98
FIXED_NTVDMSTATE_SEGMENT equ 00060H
else
FIXED_NTVDMSTATE_SEGMENT equ 00070H
endif
FIXED_NTVDMSTATE_OFFSET equ 00014H
FIXED_NTVDMSTATE_LINEAR EQU     ((FIXED_NTVDMSTATE_SEGMENT  SHL  4 ) + FIXED_NTVDMSTATE_OFFSET)
FIXED_NTVDMSTATE_SIZE equ 00004H

;
;  VdmFlags
;

VDM_INT_HARDWARE equ 00001H
VDM_INT_TIMER equ 00002H
VDM_INTERRUPT_PENDING equ 00003H
VDM_INTS_HOOKED_IN_PM equ 00004H
VDM_BREAK_EXCEPTIONS equ 00008H
VDM_BREAK_DEBUGGER equ 00010H
VDM_PROFILE equ 00020H
VDM_ANALYZE_PROFILE equ 00040H
VDM_TRACE_HISTORY equ 00080H
VDM_32BIT_APP equ 00100H
VDM_VIRTUAL_INTERRUPTS equ 00200H
VDM_VIRTUAL_AC equ 040000H
VDM_VIRTUAL_NT equ 04000H
MIPS_BIT_MASK equ 00400H
VDM_ON_MIPS equ 00400H
VDM_EXEC equ 00800H
VDM_RM equ 01000H
VDM_USE_DBG_VDMEVENT equ 04000H
VDM_WOWBLOCKED equ 0100000H
VDM_IDLEACTIVITY equ 0200000H
VDM_WOWHUNGAPP equ 0800000H
VDM_PE_MASK equ 080000000H

;
;  Interrupt handler flags
;

VDM_INT_INT_GATE equ 00001H
VDM_INT_TRAP_GATE equ 00000H
VDM_INT_32 equ 00002H
VDM_INT_16 equ 00000H
VDM_INT_HOOKED equ 00004H

;
;  EFlags values
;

EFLAGS_TF_MASK equ 00100H
EFLAGS_INTERRUPT_MASK equ 00200H
EFLAGS_IOPL_MASK equ 03000H
EFLAGS_NT_MASK equ 04000H

;
;  Selector Flags
;

SEL_TYPE_READ equ 00001H
SEL_TYPE_WRITE equ 00002H
SEL_TYPE_EXECUTE equ 00004H
SEL_TYPE_BIG equ 00008H
SEL_TYPE_ED equ 00010H
SEL_TYPE_2GIG equ 00020H

;
;  VdmEvent Enumerations
;

VdmIO equ 00000H
VdmStringIO equ 00001H
VdmMemAccess equ 00002H
VdmIntAck equ 00003H
VdmBop equ 00004H
VdmError equ 00005H
VdmIrq13 equ 00006H
VdmMaxEvent equ 00007H

;
;  VdmTib offsets
;

VtMonitorContext equ 0000CH
VtVdmContext equ 002D8H
VtInterruptTable equ 00004H
VtFaultTable equ 00008H
VtEventInfo equ 005A4H
VtEIEvent equ 005A8H
VtEIInstSize equ 005ACH
VtEIBopNumber equ 005B0H
VtEIIntAckInfo equ 005B0H
VtDpmiInfo equ 00634H
EiEvent equ 00004H
EiInstructionSize equ 00008H
EiBopNumber equ 0000CH
EiIntAckInfo equ 0000CH

;
;  WOW TD offsets
;

WtdFastWowEsp equ 00008H

;
;  VdmInterrupHandler offsets
;

ViCsSelector equ 00000H
ViEip equ 00004H
ViFlags equ 00002H
VDM_INTERRUPT_HANDLER_SIZE equ 00008H

;
;  VdmFaultHandler offsets
;

VfCsSelector equ 00000H
VfEip equ 00004H
VfSsSelector equ 00002H
VfEsp equ 00008H
VfFlags equ 0000CH
VDM_FAULT_HANDLER_SIZE equ 00010H

;
;  VdmDpmiInfo offsets
;

VpLockCount equ 00000H
VpFlags equ 00002H
VpSsSelector equ 00004H
VpSaveSsSelector equ 00006H
VpSaveEsp equ 00008H
VpSaveEip equ 0000CH
VpDosxIntIret equ 00010H
VpDosxIntIretD equ 00014H
VpDosxFaultIret equ 00018H
VpDosxFaultIretD equ 0001CH
VpDosxRmReflector equ 00020H

;
;  VdmTrace codes
;

VDMTR_KERNEL_OP_PM equ 00001H
VDMTR_KERNEL_OP_V86 equ 00002H
VDMTR_KERNEL_HW_INT equ 00003H

;
;  Misc defines
;

DBG_SINGLESTEP equ 00005H
DBG_BREAK equ 00006H
DBG_GPFAULT equ 00007H
DBG_STACKFAULT equ 00010H
STATUS_VDM_EVENT equ 040000005H

